﻿/*
 * ----------------------------------------------------
 * Copyright (c) 有栖かずみ / Arisu Kazumi
 * This software is released under the MIT license.
 * http://opensource.org/licenses/mit-license.php
 * ----------------------------------------------------
 */

/*:
 * @plugindesc アイテム画面やスキル画面の列数を変更
 * @target MZ
 * @author 有栖かずみ / Arisu Kazumi
 * @url https://a-kazumi.com/plugins
 * @help アイテムやスキルの列数をデフォルトの2列から変更できます。
 * メニュー画面と戦闘画面の両方に適用されます。
 *
 * ver1.1.0で、ショップの購入画面・売却画面の列数も変更できるようになりました。
 *
 *
 * 2024/10/10 ver1.1.0 ショップの購入画面・売却画面のアイテム列数変更にも対応
 * 2024/04/14 ver1.0.3 矢印キーでの移動の不具合を修正
 * 2024/02/18 ver1.0.2 URL表記を変更。文字コードをUTF-8のBOM付きに変更。プログラムは変更なし
 * 2024/02/06 ver1.0.1 公開用に細かいところを修正
 * 2023/06/28 ver1.0.0 作成
 *
 * @param itemCols
 * @text アイテム画面の列数
 * @desc アイテム画面の列数を1以上の整数で指定してください。
 * @default 2
 * @type number
 * @max 100
 * @min 1
 * @decimals 0
 *
 * @param skillCols
 * @text スキル画面の列数
 * @desc スキル画面の列数を1以上の整数で指定してください。
 * @default 2
 * @type number
 * @max 100
 * @min 1
 * @decimals 0
 *
 * @param itemCols_shopBuy
 * @text ショップの購入画面の列数
 * @desc 購入画面でのアイテムの列数を1以上の整数で指定してください。（デフォルト：1）
 * @default 1
 * @type number
 * @max 100
 * @min 1
 * @decimals 0
 *
 * @param itemCols_shopSell
 * @text ショップの売却画面の列数
 * @desc 売却画面でのアイテムの列数を1以上の整数で指定してください。（デフォルト：2）
 * @default 2
 * @type number
 * @max 100
 * @min 1
 * @decimals 0
 */

(() => {
    "use strict";

    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
    const params = PluginManager.parameters(pluginName);

    Window_ItemList.prototype.maxCols = function () {
        return Number(params.itemCols);
    };

    Window_SkillList.prototype.maxCols = function () {
        return Number(params.skillCols);
    };

    Window_ShopBuy.prototype.maxCols = function () {
        return Number(params.itemCols_shopBuy);
    };

    Window_ShopSell.prototype.maxCols = function () {
        return Number(params.itemCols_shopSell);
    };
})();
